/******************************************************************************/
#include "stdafx.h"
/******************************************************************************/
Mshg terrain;
/******************************************************************************/
void InitPre()
{
   App.name="Water";
   App.flag=APP_FULL_TOGGLE;
   IOPath="../data/";
   PakAdd("engine.pak");

   D.full(true).ambPower(0.3).hpRt(true).hwDepthBuffer(true);

   Cam.at.set(0,2,0);
   Cam.pitch=-0.5;
   Cam.dist =30;
   Cam.yaw  =2.8;
}
Bool Init()
{
   terrain.load("obj/terrain/0.mshg");          // terrain
   terrain.scale(Vec(1,10,1)).move(Vec(0,5,0)); // scale and move terrain vertically
   Sun.set(*Gfxs("gfx/sky/sun.gfx"));           // sun
   Sky.set();                                   // sky

   Water.set(*Gfxs("gfx/water/0.gfx"),*Gfxs("gfx/water/0.n.gfx"),Gfxs("gfx/fx/reflection.gfx")); // set water from textures

   return true;
}
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   CamHandle(0.01,500,CAMH_ZOOM|(Ms.b(1)?CAMH_MOVE:CAMH_ROT));

   // here you can optionally set different water surface plane
   if(Kb.b(KB_UP  ))Water.plane(Water.plane() + Vec(0,1,0)*Tm.d); // move water surface plane upwards
   if(Kb.b(KB_DOWN))Water.plane(Water.plane() - Vec(0,1,0)*Tm.d); // move water surface plane downwards

   // update water waves movement
   Water.update(Vec2(0.2,0.2));

   return true;
}
/******************************************************************************/
void Render()
{
   switch(Renderer())
   {
      // When rendering water, an additional rendering mode has to be used
      // RM_SOLID_M is "rendering solid in mirrors / water surfaces" mode
      // for the most simplicity you can render the same things as in RM_SOLID mode

      case RM_SOLID  :
      case RM_SOLID_M:
         terrain.draw(MatrixIdentity);
      break;
   }
}
void Draw()
{
   Renderer(Render);
   D.text(0,0.9,S+"Fps "+Tm.fps);
   D.text(0,0.8,"Press up/down keys to change water level");
}
/******************************************************************************/
